/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.fideicomiso;

import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Beneficiario
extends Sujeto {
    private static final long serialVersionUID = 6118587448753476624L;

    public Beneficiario() {
        super("tipoBeneficiario", "idBeneficiario", "7");
    }

    @Override
    public Beneficiario crearCopiaEdicion() {
        Beneficiario copiaEdicion = new Beneficiario();
        copiaEdicion.setTipoIdentificacion(super.getTipoIdentificacion());
        copiaEdicion.setIdentificacion(super.getIdentificacion());
        copiaEdicion.setDescripcionTipoIdentificacion(super.getDescripcionTipoIdentificacion());
        copiaEdicion.setTipoProveedor(super.getTipoProveedor());
        copiaEdicion.setDescripcionTipoProveedor(super.getDescripcionTipoProveedor());
        copiaEdicion.setRazonSocial(super.getRazonSocial());
        copiaEdicion.setPropietario(this.propietario);
        return copiaEdicion;
    }

    @Override
    public void actualizarInformacion(Sujeto copiaEdicion) {
        Beneficiario beneficiario = (Beneficiario)copiaEdicion;
        this.setTipoProveedor(beneficiario.getTipoProveedor());
        this.setDescripcionTipoProveedor(beneficiario.getDescripcionTipoProveedor());
        this.setRazonSocial(beneficiario.getRazonSocial());
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        if (iva.periodo.isAnexoEnPeriodoDesdeMayo2016() && "P".equals(this.getTipoIdentificacion())) {
            if (this.getTipoProveedor() == null) {
                resultado.fallarValidacion("Debe seleccionar el tipo de cliente");
                return resultado;
            }
            resultado = this.validarRazonSocial(iva.periodo, "beneficiario", resultado);
        }
        return resultado;
    }

    @Override
    public Object importar(Element detalleFideicomiso, Map<String, Element> mapaData) {
        Sujeto sujeto = (Sujeto)((Object)super.importar(detalleFideicomiso, mapaData));
        if ("P".equals(this.getTipoIdentificacion())) {
            Element eValor;
            NodeList valorList;
            if (Util.existeElementoImportar(detalleFideicomiso, "tipoBeneficiarioCli")) {
                valorList = detalleFideicomiso.getElementsByTagName("tipoBeneficiarioCli");
                eValor = (Element)valorList.item(0);
                sujeto.setTipoProveedor(eValor.getTextContent().trim());
                sujeto.setDescripcionTipoProveedor(UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOSIDPROV", (String)this.getTipoProveedor()));
            }
            if (Util.existeElementoImportar(detalleFideicomiso, "denoBenefi")) {
                valorList = detalleFideicomiso.getElementsByTagName("denoBenefi");
                eValor = (Element)valorList.item(0);
                sujeto.setRazonSocial(eValor.getTextContent().trim());
            }
        }
        return sujeto;
    }
}

